import math
import csv

#enter the weights from your model (printed at the end of training)

w1 = 0.228
w2 = 0.527
w3 = 0.569
w4 = 0.299

#you don't need to change anything else!
#When I use this to test, I'll have different testing data to make it fair.

def loss(true,pred):
    return (pred-true)**2

def activation(x):
    return math.tanh(x)

def test(crust,tomato,cheese,fingers):
    crust_z = crust * w1
    tomato_z = tomato * w2
    cheese_z = cheese * w3
    fingers_z = fingers * w4

    score = crust_z + tomato_z + cheese_z + fingers_z

    a = activation(score)

    return a

examples = []
with open('training.csv','r') as csvFile:
    csvReader = csv.reader(csvFile)
    next(csvReader)
    for row in csvReader:
        examples.append(row)
    csvFile.close()

totalLoss = 0
for example in examples:
    result = test(float(example[0])/10, float(example[1])/10, float(example[2])/10, float(example[3])/10)
    totalLoss += loss(float(example[4]), result)

print(totalLoss)
